/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.client.renderers;

import com.itayfeder.gelato_galore.items.IceCreamItem;
import com.itayfeder.gelato_galore.reload.FlavorData;
import com.itayfeder.gelato_galore.toppings.Topping;
import com.itayfeder.gelato_galore.toppings.Toppings;
import com.itayfeder.gelato_galore.utils.ScoopPattern;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class IceCreamItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Map<Integer, String[]> MODEL_FILES = new HashMap<Integer, String[]>(){
        {
            this.put(1, new String[]{""});
            this.put(2, new String[]{"bottom_", "top_"});
            this.put(3, new String[]{"right_", "left_", "top_"});
        }
    };

    public IceCreamItemRenderer() {
        super(null, null);
    }

    public void m_108829_(ItemStack p_108830_, ItemDisplayContext transform, PoseStack matrixStack, MultiBufferSource p_108833_, int light, int overlay) {
        if (p_108830_.m_41720_() instanceof IceCreamItem) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            int scoops = ((IceCreamItem)p_108830_.m_41720_()).scoops;
            matrixStack.m_85836_();
            BakedModel model = itemRenderer.m_115103_().m_109393_().getModel(new ResourceLocation("gelato_galore", String.format("item/%d_scoop/base", scoops)));
            RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)p_108830_, (boolean)true);
            VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)rendertype, (boolean)true, (boolean)p_108830_.m_41790_());
            itemRenderer.m_115189_(model, p_108830_, light, overlay, matrixStack, vertexconsumer);
            matrixStack.m_85841_(1.001f, 1.001f, 1.002f);
            matrixStack.m_252880_(0.0f, 0.0f, -0.001f);
            for (int i = 0; i < scoops; ++i) {
                FlavorData flavor = ((IceCreamItem)p_108830_.m_41720_()).getFlavor(p_108830_, i);
                if (flavor == null || flavor.patternId == 0) continue;
                ScoopPattern pattern = ScoopPattern.byId(flavor.patternId);
                model = itemRenderer.m_115103_().m_109393_().getModel(new ResourceLocation("gelato_galore", String.format("item/%d_scoop/", scoops) + MODEL_FILES.get(scoops)[i] + pattern.m_7912_()));
                rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)p_108830_, (boolean)true);
                vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)rendertype, (boolean)true, (boolean)p_108830_.m_41790_());
                this.renderModelLists(model, p_108830_, light, overlay, matrixStack, vertexconsumer, flavor.patternColor);
            }
            Topping topping = IceCreamItem.getTopping(p_108830_);
            if (!topping.location.equals((Object)Toppings.EMPTY.location)) {
                model = itemRenderer.m_115103_().m_109393_().getModel(new ResourceLocation("gelato_galore", String.format("item/%d_scoop/toppings/", scoops) + topping.location.m_135815_()));
                rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)p_108830_, (boolean)true);
                vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)rendertype, (boolean)true, (boolean)p_108830_.m_41790_());
                this.renderModelLists(model, p_108830_, light, overlay, matrixStack, vertexconsumer, topping.getColor());
            }
            matrixStack.m_85849_();
        }
    }

    public void renderModelLists(BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_, int overlayColor) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            this.renderQuadList(p_115194_, p_115195_, p_115190_.m_213637_((BlockState)null, direction, randomsource), p_115191_, p_115192_, p_115193_, overlayColor);
        }
        randomsource.m_188584_(42L);
        this.renderQuadList(p_115194_, p_115195_, p_115190_.m_213637_((BlockState)null, (Direction)null, randomsource), p_115191_, p_115192_, p_115193_, overlayColor);
    }

    public void renderQuadList(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_, int overlayColor) {
        boolean flag = !p_115166_.m_41619_();
        PoseStack.Pose posestack$pose = p_115163_.m_85850_();
        for (BakedQuad bakedquad : p_115165_) {
            float f = 1.0f;
            float f1 = 1.0f;
            float f2 = 1.0f;
            if (bakedquad.m_111305_() <= 0) {
                String hexColor = String.format("#%06X", 0xFFFFFF & overlayColor);
                Color color = Color.decode(hexColor);
                f = (float)color.getRed() / 255.0f;
                f1 = (float)color.getGreen() / 255.0f;
                f2 = (float)color.getBlue() / 255.0f;
            }
            p_115164_.putBulkData(posestack$pose, bakedquad, f, f1, f2, 1.0f, p_115167_, p_115168_, true);
        }
    }
}

